%************************* Load data ************************************
GARCH_file=xlsread('Data_Monthly_Garch');

data=GARCH_file;

% Output:
%Coeff
%GARCH specification structure containing the estimated coefficients. 
%Coeff is of the same form as the Spec input structure. 
%Toolbox functions such as garchset, garchget, garchsim, garchinfer, and garchpred can accept either Spec or Coeff as input arguments.

%************************  FORECASTING CONDITIONAL VARIANCES  ************************ 

% Set the first vintage for forecasting i=154 (1965Sept) ==) Forecast
% 1965Oct;
% Forecasting from 1965Q3- 2007Q3: 169 forecasting origin (169 observations
% in the rule)

% CUTOFF-LAST FORECASTING:  j=658=2007Sep

No=169; % Number of observations
y_var1=data(1:658,1);      
X1_3lags=data(1:658,2:4);
X1_6lags=data(1:658,2:7);
Ugap5=data(1:658,8);

% BENHMARK MODEL: 3 lags and 5 year moving average UG
X_var1=[X1_3lags Ugap5];
start_time=154;

%************************  Model specification **************************
spec = garchset('P', 1, 'Q', 1); % GARCH(1,1)

%************************  Estimation **************************

first_f=[];
second_f=[];
third_f=[];
mean_f=[];
col_sigmalas=[];
for i=1:No
    v=start_time+(i-1)*3;
    ye=y_var1(1:v); 
    Xe=X_var1(1:v,:);
    % Estimating to get parameters
[Coeff,Errors,LLF,Innovations,Sigmas,Summary]=garchfit(spec,ye,Xe);
% Arrnage parameters of sigma equation
a0=Coeff.K;
a1=Coeff.ARCH;
a2=Coeff.GARCH;
del=a1+a2;
le=length(Sigmas);
Sigmaslag=(Sigmas(le)^2);
% FORECASTING
firstforecast=a0+del*Sigmaslag;
secondforecast=a0*(1+del)+del^2*Sigmaslag;
thirdforecast=a0*(1+del+del^2)+del^3*Sigmaslag;

first_f=[first_f;firstforecast];
second_f=[second_f;secondforecast];
third_f=[third_f;thirdforecast];
meanfore=(firstforecast+secondforecast+thirdforecast)/3;
mean_f=[mean_f;meanfore];
col_sigmalas=[col_sigmalas;Sigmaslag];
end
mean_f = round(mean_f,5);
save infvar mean_f

%% PLOT THE EXPECTED INFLATION VARIANCE
plotinfv=0;
if plotinfv==1
%Set up dates
initial_year=1965;
end_year=2007;
range_year=end_year-initial_year+1
years=zeros(range_year*4,1);
number_start=4;
 
for i=1:range_year
    years(4*(i-1)+1:4*i)=initial_year*ones(1,4)+(i-1)*ones(1,4);
end
years1=years(number_start:(length(years))) % This is from 1966Q1 to 2007Q4
 

months=years;
 
for i=1:range_year
    months(4*(i-1)+1:4*i)=[1 4 7 10]';
end
months1=months(number_start:(length(months)));    % This is from 1966Q1 to 2007Q4
 
 
p=size(months1,1);
%B=[years1 months1 zeros(p,1) zeros(p,1) zeros(p,1) zeros(p,1)];
B=[years1 months1 ones(p,1) zeros(p,1) zeros(p,1) zeros(p,1)];

 dt=datenum(B);
 
 figure(100)
 %positionmeasure=[ 0 0 15 15]   
 positionmeasure=[ 0 0 20 7]   
set(gcf,'Units','centimeters','Position',positionmeasure,'PaperPositionMode','auto');
      plot(dt,mean_f,'LineWidth',1);
      datetick('x','yyyy')
      set(gca,'Units','normalized','Position',[.1 .2 .75 .7])
      
end      
clear all